/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RhukHexgoldNabberEffect
extends OneShotEffect {
    RhukHexgoldNabberEffect() {
        super(Outcome.Benefit);
    }

    private RhukHexgoldNabberEffect(RhukHexgoldNabberEffect effect) {
        super((OneShotEffect)effect);
    }

    public RhukHexgoldNabberEffect copy() {
        return new RhukHexgoldNabberEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent permanent = (Permanent)this.getValue("equippedPermanent");
        if (sourcePermanent == null || permanent == null) {
            return false;
        }
        for (UUID attachmentId : permanent.getAttachments()) {
            Permanent attachment = game.getPermanent(attachmentId);
            if (attachment == null || !attachment.hasSubtype(SubType.EQUIPMENT, game)) continue;
            sourcePermanent.addAttachment(attachmentId, source, game);
        }
        return true;
    }
}

