/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.ManaUtil;

class RhysticStudyDrawEffect
extends OneShotEffect {
    RhysticStudyDrawEffect() {
        super(Outcome.DrawCard);
        this.staticText = "you may draw a card unless that player pays {1}";
    }

    private RhysticStudyDrawEffect(RhysticStudyDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public RhysticStudyDrawEffect copy() {
        return new RhysticStudyDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && opponent != null && sourceObject != null) {
            if (controller.chooseUse(Outcome.DrawCard, "Draw a card (" + sourceObject.getLogName() + ')', source, game)) {
                ManaCost cost = ManaUtil.createManaCost((int)1, (boolean)false);
                if (opponent.chooseUse(Outcome.Benefit, "Pay {1}?", source, game) && cost.pay(source, game, source, opponent.getId(), false, null)) {
                    return true;
                }
                controller.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }
}

