/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RichesEffect
extends OneShotEffect {
    RichesEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent chooses a creature they control. You gain control of those creatures.";
    }

    private RichesEffect(RichesEffect effect) {
        super((OneShotEffect)effect);
    }

    public RichesEffect copy() {
        return new RichesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            CardsImpl creaturesToSteal = new CardsImpl();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player opponent;
                if (!controller.hasOpponent(playerId, game) || (opponent = game.getPlayer(playerId)) == null) continue;
                TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
                target.withNotTarget(true);
                if (!opponent.choose(Outcome.Detriment, (Target)target, source, game)) continue;
                creaturesToSteal.add(target.getTargets().get(0));
            }
            for (UUID target : creaturesToSteal) {
                GainControlTargetEffect eff = new GainControlTargetEffect(Duration.EndOfGame, true);
                eff.setTargetPointer((TargetPointer)new FixedTarget(target, game));
                game.addEffect((ContinuousEffect)eff, source);
            }
            return true;
        }
        return false;
    }
}

