/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RiddleOfLightningEffect
extends OneShotEffect {
    RiddleOfLightningEffect() {
        super(Outcome.Damage);
        this.staticText = ", then reveal the top card of your library. {this} deals damage equal to that card's mana value to that permanent or player";
    }

    private RiddleOfLightningEffect(RiddleOfLightningEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiddleOfLightningEffect copy() {
        return new RiddleOfLightningEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card sourceCard = game.getCard(source.getSourceId());
        if (sourceCard != null && controller != null) {
            if (controller.getLibrary().hasCards()) {
                Card card = controller.getLibrary().getFromTop(game);
                controller.revealCards(sourceCard.getName(), (Cards)new CardsImpl(card), game);
                Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (targetCreature != null) {
                    targetCreature.damage(card.getManaValue(), source.getSourceId(), source, game, false, true);
                    return true;
                }
                Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
                if (targetPlayer != null) {
                    targetPlayer.damage(card.getManaValue(), source.getSourceId(), source, game);
                    return true;
                }
            }
            return true;
        }
        return false;
    }
}

