/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class RideTheAvalancheWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    public RideTheAvalancheWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST) {
            this.playerSet.remove(event.getPlayerId());
        }
    }

    public static void addPlayer(UUID playerId, Game game) {
        ((RideTheAvalancheWatcher)game.getState().getWatcher(RideTheAvalancheWatcher.class)).playerSet.add(playerId);
    }

    public static boolean checkPlayer(UUID playerId, Game game) {
        return ((RideTheAvalancheWatcher)game.getState().getWatcher(RideTheAvalancheWatcher.class)).playerSet.contains(playerId);
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }
}

