/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.HumanSoldierToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class RidersOfTheMarkEffect
extends OneShotEffect {
    RidersOfTheMarkEffect() {
        super(Outcome.Benefit);
        this.staticText = "return it to its owner's hand. If you do, create a number of 1/1 white Human Soldier creature tokens equal to its toughness.";
    }

    private RidersOfTheMarkEffect(RidersOfTheMarkEffect effect) {
        super((OneShotEffect)effect);
    }

    public RidersOfTheMarkEffect copy() {
        return new RidersOfTheMarkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Player player = game.getPlayer(source.getControllerId());
        if (permanent == null || player == null) {
            return false;
        }
        int toughness = permanent.getToughness().getValue();
        if (!player.moveCards((Card)permanent, Zone.HAND, source, game)) {
            return false;
        }
        if (toughness > 0) {
            new CreateTokenEffect((Token)new HumanSoldierToken(), toughness).apply(game, source);
        }
        return true;
    }
}

