/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToHandTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RienneAngelOfRebirthEffect
extends OneShotEffect {
    RienneAngelOfRebirthEffect() {
        super(Outcome.PutCardInPlay);
    }

    private RienneAngelOfRebirthEffect(RienneAngelOfRebirthEffect effect) {
        super((OneShotEffect)effect);
    }

    public RienneAngelOfRebirthEffect copy() {
        return new RienneAngelOfRebirthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card != null && game.getState().getZone(card.getId()) == Zone.GRAVEYARD) {
            ReturnFromGraveyardToHandTargetEffect effect = new ReturnFromGraveyardToHandTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            effect.setText("return that card to your hand at the beginning of the next end step");
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
            return true;
        }
        return false;
    }
}

