/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.r.RienneAngelOfRebirthEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RienneAngelOfRebirthTriggeredAbility
extends TriggeredAbilityImpl {
    RienneAngelOfRebirthTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new RienneAngelOfRebirthEffect(), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private RienneAngelOfRebirthTriggeredAbility(RienneAngelOfRebirthTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RienneAngelOfRebirthTriggeredAbility copy() {
        return new RienneAngelOfRebirthTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getTarget() == null || zEvent.getTarget().getId().equals(this.getSourceId())) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(zEvent.getTarget().getId());
        if (permanent != null && zEvent.isDiesEvent() && permanent.isCreature(game) && permanent.getColor(game).isMulticolored() && permanent.isControlledBy(this.controllerId)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(zEvent.getTargetId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever another multicolored creature you control dies, return it to its owner's hand at the beginning of the next end step.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

