/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.ObjectColor;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RighteousIndignationTriggeredAbility
extends TriggeredAbilityImpl {
    public RighteousIndignationTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostTargetEffect(1, 1, Duration.EndOfTurn));
    }

    private RighteousIndignationTriggeredAbility(RighteousIndignationTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RighteousIndignationTriggeredAbility copy() {
        return new RighteousIndignationTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent blocker = game.getPermanent(event.getSourceId());
        Permanent blocked = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (blocker != null && blocked != null && (blocked.getColor(game).contains(ObjectColor.BLACK) || blocked.getColor(game).contains(ObjectColor.RED))) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(blocker.getId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature blocks a black or red creature, the blocking creature gets +1/+1 until end of turn.";
    }
}

