/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RighteousValkyrieEffect
extends OneShotEffect {
    RighteousValkyrieEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain life equal to that creature's toughness";
    }

    private RighteousValkyrieEffect(RighteousValkyrieEffect effect) {
        super((OneShotEffect)effect);
    }

    public RighteousValkyrieEffect copy() {
        return new RighteousValkyrieEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (player == null || permanent == null) {
            return false;
        }
        player.gainLife(permanent.getToughness().getValue(), game, source);
        return true;
    }
}

