/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.WishEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class RingOfMarufEffect
extends ReplacementEffectImpl {
    RingOfMarufEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "The next time you would draw a card this turn, instead put a card you own from outside the game into your hand";
    }

    private RingOfMarufEffect(RingOfMarufEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RingOfMarufEffect copy() {
        return new RingOfMarufEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            new WishEffect().apply(game, source);
            this.discard();
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }
}

