/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class RipplesOfUndeathReturnEffect
extends OneShotEffect {
    private final Set<UUID> milledCards;

    RipplesOfUndeathReturnEffect(Set<UUID> milledCards) {
        super(Outcome.DrawCard);
        this.staticText = "put a card from among those cards into your hand";
        this.milledCards = milledCards;
    }

    private RipplesOfUndeathReturnEffect(RipplesOfUndeathReturnEffect effect) {
        super((OneShotEffect)effect);
        this.milledCards = new HashSet<UUID>(effect.milledCards);
    }

    public RipplesOfUndeathReturnEffect copy() {
        return new RipplesOfUndeathReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (this.milledCards.isEmpty() || controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAll(this.milledCards);
        TargetCardInGraveyard target = new TargetCardInGraveyard();
        target.withNotTarget(true);
        controller.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Set returned = target.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (returned.isEmpty()) {
            return true;
        }
        controller.moveCards(returned, Zone.HAND, source, game);
        return true;
    }
}

