/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RiptideChronologistEffect
extends OneShotEffect {
    RiptideChronologistEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Untap all creatures of the creature type of your choice";
    }

    private RiptideChronologistEffect(RiptideChronologistEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ChoiceCreatureType typeChoice;
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (player != null && sourceObject != null && player.choose(this.outcome, (Choice)(typeChoice = new ChoiceCreatureType(game, source)), game)) {
            game.informPlayers(sourceObject.getLogName() + " chosen type: " + typeChoice.getChoiceKey());
            FilterCreaturePermanent filterCreaturePermanent = new FilterCreaturePermanent();
            filterCreaturePermanent.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filterCreaturePermanent, source.getSourceId(), game)) {
                creature.untap(game);
            }
            return true;
        }
        return false;
    }

    public RiptideChronologistEffect copy() {
        return new RiptideChronologistEffect(this);
    }
}

