/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CountersSourceCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.RiptideReplicatorToken;

class RiptideReplicatorEffect
extends OneShotEffect {
    RiptideReplicatorEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create an X/X creature token of the chosen color and type, where X is the number of charge counters on {this}.";
    }

    private RiptideReplicatorEffect(RiptideReplicatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiptideReplicatorEffect copy() {
        return new RiptideReplicatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ObjectColor color = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color");
        SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
        if (subType == null || color == null) {
            return false;
        }
        int x = new CountersSourceCount(CounterType.CHARGE).calculate(game, source, (Effect)this);
        return new RiptideReplicatorToken(color, subType, x).putOntoBattlefield(1, game, source, source.getControllerId());
    }
}

