/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RiptideShapeshifterEffect
extends OneShotEffect {
    RiptideShapeshifterEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Choose a creature type. Reveal cards from the top of your library until you reveal a creature card of that type. Put that card onto the battlefield and shuffle the rest into your library";
    }

    private RiptideShapeshifterEffect(RiptideShapeshifterEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiptideShapeshifterEffect copy() {
        return new RiptideShapeshifterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            ChoiceCreatureType choice = new ChoiceCreatureType(game, source);
            if (!controller.choose(Outcome.BoostCreature, (Choice)choice, game)) {
                return false;
            }
            CardsImpl revealedCards = new CardsImpl();
            for (Card card : controller.getLibrary().getCards(game)) {
                if (card.isCreature(game) && card.hasSubtype(SubType.byDescription((String)choice.getChoiceKey()), game)) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                    break;
                }
                revealedCards.add(card);
            }
            controller.revealCards(sourceObject.getIdName(), (Cards)revealedCards, game);
            controller.moveCards((Cards)revealedCards, Zone.LIBRARY, source, game);
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

