/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RiseOfTheDarkRealmsEffect
extends OneShotEffect {
    RiseOfTheDarkRealmsEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Put all creature cards from all graveyards onto the battlefield under your control";
    }

    private RiseOfTheDarkRealmsEffect(RiseOfTheDarkRealmsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            LinkedHashSet<Card> creatureCards = new LinkedHashSet<Card>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                for (Card card : player.getGraveyard().getCards(game)) {
                    if (!card.isCreature(game)) continue;
                    creatureCards.add(card);
                }
            }
            controller.moveCards(creatureCards, Zone.BATTLEFIELD, source, game, false, false, false, null);
            return true;
        }
        return false;
    }

    public RiseOfTheDarkRealmsEffect copy() {
        return new RiseOfTheDarkRealmsEffect(this);
    }
}

