/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.watchers.Watcher;

class RiseOfTheDreadMarnWatcher
extends Watcher {
    private int creaturesDied = 0;

    RiseOfTheDreadMarnWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && zEvent.getTarget().isCreature(game) && !(zEvent.getTarget() instanceof PermanentToken)) {
            ++this.creaturesDied;
        }
    }

    public void reset() {
        this.creaturesDied = 0;
        super.reset();
    }

    int getCreaturesDied() {
        return this.creaturesDied;
    }
}

