/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RiskyMoveCreatureGainControlEffect
extends ContinuousEffectImpl {
    private final UUID controller;

    RiskyMoveCreatureGainControlEffect(Duration duration, UUID controller) {
        super(duration, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.GainControl);
        this.controller = controller;
        this.staticText = "If you lose the flip, that opponent gains control of that creature";
    }

    private RiskyMoveCreatureGainControlEffect(RiskyMoveCreatureGainControlEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.controller = effect.controller;
    }

    public RiskyMoveCreatureGainControlEffect copy() {
        return new RiskyMoveCreatureGainControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            permanent = game.getPermanent(source.getFirstTarget());
        }
        if (permanent != null) {
            return permanent.changeControllerId(this.controller, game, source);
        }
        return false;
    }
}

