/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;

class RiteOfFlameManaEffect
extends ManaEffect {
    private static final FilterCard filter = new FilterCard();

    RiteOfFlameManaEffect() {
        this.staticText = "Add {R}{R}, then add {R} for each card named Rite of Flame in each graveyard";
    }

    private RiteOfFlameManaEffect(RiteOfFlameManaEffect effect) {
        super((ManaEffect)effect);
    }

    public Mana produceMana(Game game, Ability source) {
        if (game != null) {
            int count = 0;
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                count += player.getGraveyard().count(filter, game);
            }
            return Mana.RedMana((int)(count + 2));
        }
        return new Mana();
    }

    public RiteOfFlameManaEffect copy() {
        return new RiteOfFlameManaEffect(this);
    }

    static {
        filter.add((Predicate)new NamePredicate("Rite of Flame"));
    }
}

