/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RiverSongTriggeredAbility
extends TriggeredAbilityImpl {
    RiverSongTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.setTriggerPhrase("Whenever an opponent scries, surveils, or searches their library, ");
    }

    private RiverSongTriggeredAbility(RiverSongTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RiverSongTriggeredAbility copy() {
        return new RiverSongTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case SCRIED: 
            case SURVEILED: 
            case LIBRARY_SEARCHED: {
                return true;
            }
        }
        return false;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player controller = game.getPlayer(this.getControllerId());
        if (controller != null && controller.hasOpponent(event.getPlayerId(), game) && event.getPlayerId().equals(event.getTargetId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            return true;
        }
        return false;
    }
}

