/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.BlockedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RoarOfJukaiEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("Forest");
    private static final FilterCreaturePermanent filterBlocked = new FilterCreaturePermanent("blocked creature");

    public RoarOfJukaiEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "If you control a Forest, each blocked creature gets +2/+2 until end of turn";
    }

    private RoarOfJukaiEffect(RoarOfJukaiEffect effect) {
        super((OneShotEffect)effect);
    }

    public RoarOfJukaiEffect copy() {
        return new RoarOfJukaiEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (new PermanentsOnTheBattlefieldCondition(filter).apply(game, source)) {
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filterBlocked, source.getControllerId(), source, game)) {
                    BoostTargetEffect effect = new BoostTargetEffect(2, 2, Duration.EndOfTurn);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.FOREST.getPredicate());
        filterBlocked.add((Predicate)BlockedPredicate.instance);
    }
}

