/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.SpellsCastWatcher;

class RockJockeyEffect
extends ContinuousRuleModifyingEffectImpl {
    RockJockeyEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "You can't play lands if you've cast {this} this turn";
    }

    private RockJockeyEffect(RockJockeyEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public RockJockeyEffect copy() {
        return new RockJockeyEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PLAY_LAND;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getPlayerId().equals(source.getControllerId())) {
            return false;
        }
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        if (watcher == null) {
            return false;
        }
        return watcher.getSpellsCastThisTurn(source.getControllerId()).stream().filter(Objects::nonNull).anyMatch(spell -> spell.getSourceId().equals(source.getSourceId()));
    }
}

