/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class RodOfAbsorptionExileEffect
extends ReplacementEffectImpl {
    private final MageObjectReference morSpell;
    private final MageObjectReference morCard;

    RodOfAbsorptionExileEffect(Spell spell, Game game) {
        super(Duration.WhileOnStack, Outcome.Benefit);
        this.morSpell = new MageObjectReference((MageObject)spell.getCard(), game);
        this.morCard = new MageObjectReference((MageObject)spell.getMainCard(), game);
    }

    private RodOfAbsorptionExileEffect(RodOfAbsorptionExileEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.morSpell = effect.morSpell;
        this.morCard = effect.morCard;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Spell sourceSpell = this.morSpell.getSpell(game);
        if (sourceSpell == null || sourceSpell.isCopy()) {
            return false;
        }
        Player player = game.getPlayer(sourceSpell.getOwnerId());
        if (player == null) {
            return false;
        }
        player.moveCardsToExile((Card)sourceSpell, source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return Zone.STACK.equals((Object)zEvent.getFromZone()) && Zone.GRAVEYARD.equals((Object)zEvent.getToZone()) && this.morSpell.refersTo(event.getSourceId(), game) && this.morCard.refersTo(event.getTargetId(), game);
    }

    public RodOfAbsorptionExileEffect copy() {
        return new RodOfAbsorptionExileEffect(this);
    }
}

