/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetCardInYourGraveyard;

class RofellossGiftEffect
extends OneShotEffect {
    public static final FilterCard filter1 = new FilterCard("green cards in your hand");
    public static final FilterCard filter2 = new FilterCard("enchantment cards in your graveyard");

    public RofellossGiftEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal any number of green cards in your hand. Return an enchantment card from your graveyard to your hand for each card revealed this way.";
    }

    private RofellossGiftEffect(RofellossGiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public RofellossGiftEffect copy() {
        return new RofellossGiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand targetCardInHand = new TargetCardInHand(0, Integer.MAX_VALUE, filter1);
        if (!player.choose(this.outcome, player.getHand(), (TargetCard)targetCardInHand, source, game)) {
            return false;
        }
        CardsImpl revealedCards = new CardsImpl((Collection)targetCardInHand.getTargets());
        player.revealCards(source, (Cards)revealedCards, game);
        int enchantmentsToReturn = Math.min(player.getGraveyard().count(filter2, game), targetCardInHand.getTargets().size());
        TargetCardInYourGraveyard targetCardInYourGraveyard = new TargetCardInYourGraveyard(enchantmentsToReturn, filter2);
        targetCardInYourGraveyard.withNotTarget(true);
        if (!player.choose(this.outcome, (Target)targetCardInYourGraveyard, source, game)) {
            return false;
        }
        CardsImpl returnedCards = new CardsImpl((Collection)targetCardInYourGraveyard.getTargets());
        return player.moveCards((Cards)returnedCards, Zone.HAND, source, game);
    }

    static {
        filter1.add((Predicate)new ColorPredicate(ObjectColor.GREEN));
        filter2.add((Predicate)CardType.ENCHANTMENT.getPredicate());
    }
}

