/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.SubType;
import mage.game.Game;
import mage.watchers.common.AttackedThisTurnWatcher;

class RogueAttackedThisTurnCondition
implements Condition {
    private Ability ability;

    RogueAttackedThisTurnCondition(Ability source) {
        this.ability = source;
    }

    public boolean apply(Game game, Ability source) {
        if (this.ability == null) {
            this.ability = source;
        }
        if (!this.ability.isControlledBy(game.getActivePlayerId())) {
            return false;
        }
        AttackedThisTurnWatcher watcher = (AttackedThisTurnWatcher)game.getState().getWatcher(AttackedThisTurnWatcher.class);
        return watcher != null && watcher.getAttackedThisTurnCreaturesPermanentLKI().stream().map(permanent -> permanent).filter(Objects::nonNull).anyMatch(permanent -> permanent.hasSubtype(SubType.ROGUE, game));
    }

    public String toString() {
        return "You attacked with a Rogue this turn";
    }
}

