/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.util.CardUtil;

class RogueClassManaEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    RogueClassManaEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = ", and you may spend mana as though it were mana of any color to cast those spells";
    }

    private RogueClassManaEffect(RogueClassManaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public RogueClassManaEffect copy() {
        return new RogueClassManaEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        MageObject sourceObject = source.getSourceObject(game);
        Card theCard = game.getCard(objectId);
        if (theCard == null) {
            return false;
        }
        objectId = theCard.getMainCard().getId();
        int zcc = game.getState().getZoneChangeCounter(theCard.getId());
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)sourceObject.getId(), (int)sourceObject.getZoneChangeCounter(game));
        UUID storedExileIdOfTheCard = (UUID)game.getState().getValue(theCard.getId().toString() + (zcc - 1));
        if (objectId != null && game.getState().getZone(objectId) == Zone.STACK && exileId == storedExileIdOfTheCard && affectedControllerId.equals(source.getControllerId())) {
            Card card = game.getCard(objectId);
            return card != null;
        }
        return false;
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }
}

