/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.RemoveAllCountersSourceEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.util.ManaUtil;

class RogueSkycaptainEffect
extends OneShotEffect {
    RogueSkycaptainEffect() {
        super(Outcome.GainControl);
        this.staticText = "put a wage counter on {this}. You may pay {2} for each wage counter on it. If you don't, remove all wage counters from {this} and an opponent gains control of it";
    }

    private RogueSkycaptainEffect(RogueSkycaptainEffect effect) {
        super((OneShotEffect)effect);
    }

    public RogueSkycaptainEffect copy() {
        return new RogueSkycaptainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && permanent != null) {
            new AddCountersSourceEffect(CounterType.WAGE.createInstance(), true).apply(game, source);
            ManaCost cost = ManaUtil.createManaCost((int)(2 * permanent.getCounters(game).getCount(CounterType.WAGE)), (boolean)false);
            if (!cost.pay(source, game, source, controller.getId(), false)) {
                Player opponent;
                new RemoveAllCountersSourceEffect(CounterType.WAGE).apply(game, source);
                Set opponents = game.getOpponents(controller.getId());
                if (opponents.size() == 1) {
                    opponent = game.getPlayer((UUID)opponents.iterator().next());
                } else {
                    TargetOpponent target = new TargetOpponent(true);
                    target.withNotTarget(true);
                    target.choose(Outcome.GainControl, source.getControllerId(), source.getSourceId(), source, game);
                    opponent = game.getPlayer(target.getFirstTarget());
                }
                if (opponent != null) {
                    permanent.changeControllerId(opponent.getId(), game, source);
                }
            }
            return true;
        }
        return false;
    }
}

