/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.TapAllEffect;
import mage.abilities.effects.common.continuous.GainControlAllEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RohgahhOfKherKeepEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures named Kobolds of Kher Keep");

    RohgahhOfKherKeepEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {R}{R}{R}. If you don't, tap {this} and all creatures named Kobolds of Kher Keep, then an opponent gains control of them.";
    }

    private RohgahhOfKherKeepEffect(RohgahhOfKherKeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public RohgahhOfKherKeepEffect copy() {
        return new RohgahhOfKherKeepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player == null) {
            return false;
        }
        ManaCostsImpl cost = new ManaCostsImpl("{R}{R}{R}");
        if (!(cost.canPay(source, source, player.getId(), game) && player.chooseUse(Outcome.Benefit, "Pay {R}{R}{R}?", source, game) && cost.pay(source, game, source, player.getId(), false))) {
            TargetOpponent target = new TargetOpponent();
            Player opponent = null;
            if (target.choose(Outcome.Detriment, player.getId(), source.getSourceId(), source, game)) {
                opponent = game.getPlayer(target.getFirstTarget());
            }
            new TapAllEffect((FilterPermanent)filter).apply(game, source);
            if (permanent != null) {
                permanent.tap(source, game);
            }
            if (opponent != null) {
                new GainControlAllEffect(Duration.Custom, (FilterPermanent)filter, opponent.getId()).apply(game, source);
                if (permanent != null) {
                    GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, true, opponent.getId());
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)new NamePredicate("Kobolds of Kher Keep"));
    }
}

