/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Library;
import mage.players.Player;

class RohirrimChargersEffect
extends OneShotEffect {
    RohirrimChargersEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal cards from the top of your library until you reveal an Equipment card. Put that card onto the battlefield attached to that creature, then put the rest on the bottom of your library in a random order.";
    }

    private RohirrimChargersEffect(RohirrimChargersEffect effect) {
        super((OneShotEffect)effect);
    }

    public RohirrimChargersEffect copy() {
        return new RohirrimChargersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Library library = player.getLibrary();
        if (!library.hasCards()) {
            return true;
        }
        CardsImpl cards = new CardsImpl();
        Card toBattlefield = null;
        for (Card card : library.getCards(game)) {
            cards.add(card);
            if (!card.hasSubtype(SubType.EQUIPMENT, game)) continue;
            toBattlefield = card;
            break;
        }
        if (toBattlefield != null) {
            Permanent attachTarget = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (attachTarget != null) {
                game.getState().setValue("attachTo:" + toBattlefield.getId(), (Object)attachTarget);
            }
            player.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game);
            if (attachTarget != null) {
                attachTarget.addAttachment(toBattlefield.getId(), source, game);
            }
        }
        player.revealCards(source, (Cards)cards, game);
        cards.remove(toBattlefield);
        if (!cards.isEmpty()) {
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }
}

