/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class RonaDiscipleOfGixPlayNonLandEffect
extends AsThoughEffectImpl {
    RonaDiscipleOfGixPlayNonLandEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "You may cast nonland cards exiled with {this}";
    }

    private RonaDiscipleOfGixPlayNonLandEffect(RonaDiscipleOfGixPlayNonLandEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public RonaDiscipleOfGixPlayNonLandEffect copy() {
        return new RonaDiscipleOfGixPlayNonLandEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (affectedControllerId.equals(source.getControllerId())) {
            UUID exileId;
            Card card = game.getCard(objectId);
            MageObject sourceObject = game.getObject(source);
            if (card != null && !card.isLand(game) && sourceObject != null && (exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)sourceObject.getZoneChangeCounter(game))) != null) {
                ExileZone exileZone = game.getState().getExile().getExileZone(exileId);
                return exileZone != null && exileZone.contains((Object)objectId);
            }
        }
        return false;
    }
}

