/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class RootSliverEffect
extends ContinuousRuleModifyingEffectImpl {
    RootSliverEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Sliver spells can't be countered";
    }

    private RootSliverEffect(RootSliverEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public RootSliverEffect copy() {
        return new RootSliverEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject sourceObject;
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && spell.hasSubtype(SubType.SLIVER, game) && (sourceObject = game.getObject(event.getSourceId())) instanceof StackObject;
    }
}

