/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class RootingKavuEffect
extends OneShotEffect {
    RootingKavuEffect() {
        super(Outcome.Benefit);
        this.staticText = "shuffle all creature cards from your graveyard into your library.";
    }

    private RootingKavuEffect(RootingKavuEffect effect) {
        super((OneShotEffect)effect);
    }

    public RootingKavuEffect copy() {
        return new RootingKavuEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl(controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
            controller.putCardsOnTopOfLibrary((Cards)cards, game, source, false);
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

