/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class RootweaverDruidEffect
extends OneShotEffect {
    RootweaverDruidEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent may search their library for up to three basic land cards. They each put one of those cards onto the battlefield tapped under your control and the rest onto the battlefield tapped under their control. Then each player who searched their library this way shuffles";
    }

    private RootweaverDruidEffect(RootweaverDruidEffect effect) {
        super((OneShotEffect)effect);
    }

    public RootweaverDruidEffect copy() {
        return new RootweaverDruidEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl mine = new CardsImpl();
        CardsImpl theirs = new CardsImpl();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.chooseUse(this.outcome, "Search your library?", source, game)) continue;
            TargetCardInLibrary target = new TargetCardInLibrary(0, 3, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
            player.searchLibrary(target, source, game);
            player.shuffleLibrary(source, game);
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            if (cards.isEmpty()) continue;
            target = new TargetCardInLibrary();
            player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
            mine.addAll((Collection)target.getTargets());
            cards.removeAll((Collection)target.getTargets());
            theirs.addAll((Collection)cards);
        }
        controller.moveCards(mine.getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        controller.moveCards(theirs.getCards(game), Zone.BATTLEFIELD, source, game, true, false, true, null);
        return true;
    }
}

