/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;
import mage.watchers.common.AbilityResolvedWatcher;

class RoseRoomTreasurerEffect
extends OneShotEffect {
    RoseRoomTreasurerEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a Treasure token if this is the first or second time this ability has resolved this turn. Otherwise, you may pay {X}. When you do, {this} deals X damage to any target";
    }

    private RoseRoomTreasurerEffect(RoseRoomTreasurerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RoseRoomTreasurerEffect copy() {
        return new RoseRoomTreasurerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (AbilityResolvedWatcher.getResolutionCount((Game)game, (Ability)source) <= 2) {
            return new TreasureToken().putOntoBattlefield(1, game, source);
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ManaCostsImpl cost = new ManaCostsImpl("{X}");
        if (!player.chooseUse(Outcome.BoostCreature, "Pay {X}?", source, game)) {
            return false;
        }
        int costX = player.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to damage)", game, source, true);
        cost.add((Object)new GenericManaCost(costX));
        if (!cost.pay(source, game, source, source.getControllerId(), false)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(costX), false);
        ability.addTarget((Target)new TargetAnyTarget());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

