/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RotfeasterMaggotExileEffect
extends OneShotEffect {
    RotfeasterMaggotExileEffect() {
        super(Outcome.GainLife);
        this.staticText = "exile target creature card from a graveyard. You gain life equal to that card's toughness";
    }

    private RotfeasterMaggotExileEffect(RotfeasterMaggotExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public RotfeasterMaggotExileEffect copy() {
        return new RotfeasterMaggotExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card targetCard;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (targetCard = game.getCard(this.getTargetPointer().getFirst(game, source))) != null) {
            if (game.getState().getZone(targetCard.getId()) == Zone.GRAVEYARD) {
                controller.moveCardToExileWithInfo(targetCard, null, "", source, game, Zone.GRAVEYARD, true);
            }
            controller.gainLife(targetCard.getToughness().getValue(), game, source);
            return true;
        }
        return false;
    }
}

