/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RumblingAftershocksDealDamageEffect
extends OneShotEffect {
    RumblingAftershocksDealDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "you may have {this} deal damage to any target equal to the number of times that spell was kicked";
    }

    private RumblingAftershocksDealDamageEffect(RumblingAftershocksDealDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public RumblingAftershocksDealDamageEffect copy() {
        return new RumblingAftershocksDealDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Integer damageAmount = (Integer)this.getValue("damageAmount");
        if (player != null && damageAmount > 0) {
            Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (targetPlayer != null) {
                targetPlayer.damage(damageAmount.intValue(), source.getSourceId(), source, game);
                return true;
            }
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                permanent.damage(damageAmount.intValue(), source.getSourceId(), source, game, false, true);
                return true;
            }
        }
        return false;
    }
}

