/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBlockAllEffect;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.common.FilterOpponentsCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RumblingRuinEffect
extends OneShotEffect {
    RumblingRuinEffect() {
        super(Outcome.Benefit);
        this.staticText = "count the number of +1/+1 counters on creatures you control. Creatures your opponents control with power less than or equal to that number can't block this turn.";
    }

    private RumblingRuinEffect(RumblingRuinEffect effect) {
        super((OneShotEffect)effect);
    }

    public RumblingRuinEffect copy() {
        return new RumblingRuinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int counter = 1;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (permanent == null || !permanent.isCreature(game)) continue;
            counter += permanent.getCounters(game).getCount(CounterType.P1P1);
        }
        FilterOpponentsCreaturePermanent filter = new FilterOpponentsCreaturePermanent();
        filter.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, counter));
        game.addEffect((ContinuousEffect)new CantBlockAllEffect((FilterCreaturePermanent)filter, Duration.EndOfTurn), source);
        return true;
    }
}

