/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class RunadiBehemothCallerCounterEffect
extends ReplacementEffectImpl {
    RunadiBehemothCallerCounterEffect() {
        super(Duration.EndOfTurn, Outcome.BoostCreature);
        this.staticText = "that creature enters the battlefield with X additional +1/+1 counters on it, where X is its mana value minus 4";
    }

    private RunadiBehemothCallerCounterEffect(RunadiBehemothCallerCounterEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RunadiBehemothCallerCounterEffect copy() {
        return new RunadiBehemothCallerCounterEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        return spell != null && event.getTargetId().equals(spell.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Spell spell;
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature != null && (spell = game.getSpellOrLKIStack(creature.getId())) != null) {
            int countersToAdd = spell.getManaValue() - 4;
            creature.addCounters(CounterType.P1P1.createInstance(countersToAdd), source.getControllerId(), source, game, event.getAppliedEffects());
        }
        return false;
    }
}

