/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class RundveltHordemasterEffect
extends OneShotEffect {
    RundveltHordemasterEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. If it's a Goblin creature card, you may cast that card until the end of your next turn";
    }

    private RundveltHordemasterEffect(RundveltHordemasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public RundveltHordemasterEffect copy() {
        return new RundveltHordemasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (card.isCreature(game) && card.hasSubtype(SubType.GOBLIN, game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)false);
        }
        return true;
    }
}

