/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTappedAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.CantBeBlockedTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetadjustment.TargetAdjuster;
import mage.target.targetadjustment.XTargetsCountAdjuster;

public final class RunedArch
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("creatures with power 2 or less");

    public RunedArch(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{3}");
        this.addAbility((Ability)new EntersBattlefieldTappedAbility());
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new CantBeBlockedTargetEffect(Duration.EndOfGame).setText("X target creatures with power 2 or less can't be blocked this turn."), (Cost)new ManaCostsImpl("{X}"));
        ability.addCost((Cost)new TapSourceCost());
        ability.addCost((Cost)new SacrificeSourceCost());
        ability.addTarget((Target)new TargetPermanent(filter));
        ability.setTargetAdjuster((TargetAdjuster)new XTargetsCountAdjuster());
        this.addAbility((Ability)ability);
    }

    private RunedArch(RunedArch card) {
        super((CardImpl)card);
    }

    public RunedArch copy() {
        return new RunedArch(this);
    }

    static {
        filter.add((Predicate)CardType.CREATURE.getPredicate());
        filter.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 3));
    }
}

