/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class RustElementalEffect
extends OneShotEffect {
    private static final FilterControlledArtifactPermanent filter = new FilterControlledArtifactPermanent("artifact");

    RustElementalEffect() {
        super(Outcome.Damage);
        this.staticText = "sacrifice another artifact. If you can't, tap {this} and you lose 4 life.";
    }

    private RustElementalEffect(RustElementalEffect effect) {
        super((OneShotEffect)effect);
    }

    public RustElementalEffect copy() {
        return new RustElementalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourceObject != null) {
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                TargetSacrifice target = new TargetSacrifice((FilterPermanent)filter);
                if (target.canChoose(controller.getId(), source, game)) {
                    controller.choose(Outcome.Sacrifice, (Target)target, source, game);
                    Permanent artifactSacrifice = game.getPermanent(target.getFirstTarget());
                    if (artifactSacrifice != null) {
                        artifactSacrifice.sacrifice(source, game);
                    }
                } else {
                    sourceObject.tap(source, game);
                    controller.damage(4, source.getSourceId(), source, game);
                }
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

