/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Optional;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class RyanSinclairEffect
extends OneShotEffect {
    RyanSinclairEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards from the top of your library until you exile a nonland card. You may cast the exiled card without paying its mana cost if it's a spell with mana value less than or equal to {this}'s power. Put the exiled cards not cast this way on the bottom of your library in a random order";
    }

    private RyanSinclairEffect(RyanSinclairEffect effect) {
        super((OneShotEffect)effect);
    }

    public RyanSinclairEffect copy() {
        return new RyanSinclairEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Card card = RyanSinclairEffect.getCard(player, (Cards)cards, source, game);
        if (card != null) {
            FilterCard filter = new FilterCard();
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, Optional.ofNullable(source.getSourcePermanentOrLKI(game)).map(MageObject::getPower).map(MageInt::getValue).orElse(-1).intValue()));
            CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Card)card, (FilterCard)filter);
        }
        cards.retainZone(Zone.EXILED, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    private static Card getCard(Player player, Cards cards, Ability source, Game game) {
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            player.moveCards(card, Zone.EXILED, source, game);
            if (card.isLand(game)) continue;
            return card;
        }
        return null;
    }
}

