/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldWithCounterTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class RydiaSummonerOfMistEffect
extends ReturnFromGraveyardToBattlefieldWithCounterTargetEffect {
    RydiaSummonerOfMistEffect() {
        super(new Counter[]{CounterType.FINALITY.createInstance()});
    }

    private RydiaSummonerOfMistEffect(RydiaSummonerOfMistEffect effect) {
        super((ReturnFromGraveyardToBattlefieldWithCounterTargetEffect)effect);
    }

    public RydiaSummonerOfMistEffect copy() {
        return new RydiaSummonerOfMistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        super.apply(game, source);
        Optional.ofNullable(this.getTargetPointer().getFirst(game, source)).map(arg_0 -> ((Game)game).getCard(arg_0)).map(card -> CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)).ifPresent(permanent -> game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source));
        return true;
    }

    public String getText(Mode mode) {
        return super.getText(mode) + ". It gains haste until end of turn";
    }
}

