/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AssignNoCombatDamageSourceEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RysorianBadgerEffect
extends OneShotEffect {
    RysorianBadgerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile up to two target creature cards from defending player's graveyard. If you do, you gain 1 life for each card exiled this way and {this} assigns no combat damage this turn.";
    }

    private RysorianBadgerEffect(RysorianBadgerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RysorianBadgerEffect copy() {
        return new RysorianBadgerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cardsToExile = new CardsImpl();
        for (UUID cardId : this.getTargetPointer().getTargets(game, source)) {
            Card card = game.getCard(cardId);
            if (card == null) continue;
            cardsToExile.add(card);
        }
        int cardsExiled = 0;
        player.moveCardsToExile(cardsToExile.getCards(game), source, game, false, null, null);
        for (Card card : cardsToExile.getCards(game)) {
            if (game.getState().getZone(card.getId()) != Zone.EXILED) continue;
            ++cardsExiled;
        }
        player.gainLife(cardsExiled, game, source);
        game.addEffect((ContinuousEffect)new AssignNoCombatDamageSourceEffect(Duration.EndOfTurn), source);
        return true;
    }
}

