/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AddGlobeCountersAbility
extends TriggeredAbilityImpl {
    public AddGlobeCountersAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.GLOBE.createInstance()));
    }

    private AddGlobeCountersAbility(AddGlobeCountersAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AddGlobeCountersAbility copy() {
        return new AddGlobeCountersAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (event.getPlayerId().equals(this.getControllerId()) && (permanent = game.getPermanent(event.getSourceId())) != null && permanent.isCreature(game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature deals damage to you, put a globe counter on it.";
    }
}

