/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CantAttackSourcePlayerOrPlaneswalkerThisTurnEffect
extends RestrictionEffect {
    CantAttackSourcePlayerOrPlaneswalkerThisTurnEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "they can't attack you or planeswalkers you control this turn";
    }

    private CantAttackSourcePlayerOrPlaneswalkerThisTurnEffect(CantAttackSourcePlayerOrPlaneswalkerThisTurnEffect effect) {
        super((RestrictionEffect)effect);
    }

    public CantAttackSourcePlayerOrPlaneswalkerThisTurnEffect copy() {
        return new CantAttackSourcePlayerOrPlaneswalkerThisTurnEffect(this);
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (game.getPlayer(defenderId) != null) {
            return !source.getControllerId().equals(defenderId);
        }
        Permanent defender = game.getPermanent(defenderId);
        if (defender != null && defender.isPlaneswalker()) {
            return !source.getControllerId().equals(defender.getControllerId());
        }
        return true;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getControllerId().equals(this.getTargetPointer().getFirst(game, source));
    }
}

