/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChooseNumberEffect
extends OneShotEffect {
    ChooseNumberEffect() {
        super(Outcome.Detriment);
        this.staticText = "choose a number";
    }

    private ChooseNumberEffect(ChooseNumberEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int numberChoice = controller.getAmount(0, Integer.MAX_VALUE, "Choose a number (mana cost to restrict)", source, game);
            game.getState().setValue(source.getSourceId().toString(), (Object)numberChoice);
            Permanent permanent = game.getPermanentEntering(source.getSourceId());
            if (permanent != null) {
                permanent.addInfo("chosen players", "<font color = 'blue'>Chosen Number: " + numberChoice + "</font>", game);
                game.informPlayers(permanent.getLogName() + ", chosen number: " + numberChoice);
            }
        }
        return true;
    }

    public ChooseNumberEffect copy() {
        return new ChooseNumberEffect(this);
    }
}

