/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DeclareAttackerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.Watcher;

class CouldAttackThisTurnWatcher
extends Watcher {
    private final Set<MageObjectReference> couldAttackThisTurnCreatures = new HashSet<MageObjectReference>();

    public CouldAttackThisTurnWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DECLARE_ATTACKERS_STEP_PRE) {
            Player activePlayer = game.getPlayer(game.getActivePlayerId());
            if (activePlayer == null) {
                return;
            }
            block0: for (Permanent permanent : game.getBattlefield().getAllActivePermanents(activePlayer.getId())) {
                if (!permanent.isCreature(game)) continue;
                for (UUID defender : game.getCombat().getDefenders()) {
                    if (defender.equals(activePlayer.getId()) || !permanent.canAttack(defender, game) || game.getContinuousEffects().checkIfThereArePayCostToAttackBlockEffects((GameEvent)new DeclareAttackerEvent(defender, permanent.getId(), permanent.getControllerId()), game)) continue;
                    this.couldAttackThisTurnCreatures.add(new MageObjectReference(permanent.getId(), game));
                    continue block0;
                }
            }
        }
    }

    public Set<MageObjectReference> getCouldAttackThisTurnCreatures() {
        return this.couldAttackThisTurnCreatures;
    }

    public void reset() {
        super.reset();
        this.couldAttackThisTurnCreatures.clear();
    }
}

