/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DoUnlessAnyOpponentPaysEffect
extends OneShotEffect {
    protected Effects executingEffects = new Effects(new Effect[0]);
    private final Cost cost;
    private String chooseUseText;

    public DoUnlessAnyOpponentPaysEffect(Effect effect, Cost cost) {
        this(effect, cost, null);
    }

    public DoUnlessAnyOpponentPaysEffect(Effect effect, Cost cost, String chooseUseText) {
        super(Outcome.Benefit);
        this.executingEffects.add((Object)effect);
        this.cost = cost;
        this.chooseUseText = chooseUseText;
    }

    private DoUnlessAnyOpponentPaysEffect(DoUnlessAnyOpponentPaysEffect effect) {
        super((OneShotEffect)effect);
        this.executingEffects = effect.executingEffects.copy();
        this.cost = effect.cost.copy();
        this.chooseUseText = effect.chooseUseText;
    }

    public void addEffect(Effect effect) {
        this.executingEffects.add((Object)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            String message;
            if (this.chooseUseText == null) {
                String effectText = this.executingEffects.getText(source.getModes().getMode());
                message = "Pay " + this.cost.getText() + " to prevent (" + effectText.substring(0, effectText.length() - 1) + ")?";
            } else {
                message = this.chooseUseText;
            }
            message = CardUtil.replaceSourceName((String)message, (String)sourceObject.getName());
            boolean result = true;
            boolean doEffect = true;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.canRespond() || player.equals(controller) || !this.cost.canPay(source, source, player.getId(), game) || !player.chooseUse(Outcome.Benefit, message, source, game)) continue;
                this.cost.clearPaid();
                if (!this.cost.pay(source, game, source, player.getId(), false, null)) continue;
                if (!game.isSimulation()) {
                    game.informPlayers(player.getLogName() + " pays the cost to prevent the effect");
                }
                doEffect = false;
                break;
            }
            if (doEffect) {
                for (Effect effect : this.executingEffects) {
                    effect.setTargetPointer(this.getTargetPointer().copy());
                    if (effect instanceof OneShotEffect) {
                        result &= effect.apply(game, source);
                        continue;
                    }
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return result;
        }
        return false;
    }

    protected Player getPayingPlayer(Game game, Ability source) {
        return game.getPlayer(source.getControllerId());
    }

    public String getText(Mode mode) {
        String effectsText = this.executingEffects.getText(mode);
        return effectsText.substring(0, effectsText.length() - 1) + " unless any opponent pays " + this.cost.getText();
    }

    public DoUnlessAnyOpponentPaysEffect copy() {
        return new DoUnlessAnyOpponentPaysEffect(this);
    }
}

