/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GauntletsOfLightEffect
extends ContinuousEffectImpl {
    GauntletsOfLightEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "As long as enchanted creature has vigilance, it assigns combat damage equal to its toughness rather than its power";
    }

    private GauntletsOfLightEffect(GauntletsOfLightEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public GauntletsOfLightEffect copy() {
        return new GauntletsOfLightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null || permanent.getAttachedTo() == null) {
            return false;
        }
        Permanent attachedTo = game.getPermanent(permanent.getAttachedTo());
        if (attachedTo == null || !attachedTo.getAbilities().containsKey(VigilanceAbility.getInstance().getId())) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new PermanentIdPredicate(permanent.getAttachedTo()));
        game.getCombat().setUseToughnessForDamage(true);
        game.getCombat().addUseToughnessForDamageFilter(filter);
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

